/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import twilightforest.entity.boss.KnightPhantom;
import twilightforest.item.TFItems;

public class PhantomUpdateFormationAndMoveGoal
extends class_1352 {
    private static final float CIRCLE_SMALL_RADIUS = 2.5f;
    private static final float CIRCLE_LARGE_RADIUS = 8.5f;
    private final KnightPhantom boss;

    public PhantomUpdateFormationAndMoveGoal(KnightPhantom entity) {
        this.boss = entity;
    }

    public boolean method_6264() {
        return true;
    }

    public void method_6268() {
        this.boss.field_5960 = this.boss.getTicksProgress() % 20 != 0;
        this.boss.setTicksProgress(this.boss.getTicksProgress() + 1);
        if (this.boss.getTicksProgress() >= this.boss.getMaxTicksForFormation()) {
            this.switchToNextFormation();
        }
        class_243 dest = this.getDestination();
        this.boss.method_5962().method_6239(dest.field_1352, dest.field_1351, dest.field_1350, this.boss.isChargingAtPlayer() ? 2.0 : 1.0);
    }

    public class_243 getDestination() {
        if (!this.boss.hasHome()) {
            this.boss.method_18408(this.boss.method_24515(), 20);
        }
        return switch (this.boss.getCurrentFormation()) {
            case KnightPhantom.Formation.LARGE_CLOCKWISE -> this.getCirclePosition(8.5f, true);
            case KnightPhantom.Formation.SMALL_CLOCKWISE -> this.getCirclePosition(2.5f, true);
            case KnightPhantom.Formation.LARGE_ANTICLOCKWISE -> this.getCirclePosition(8.5f, false);
            case KnightPhantom.Formation.SMALL_ANTICLOCKWISE -> this.getCirclePosition(2.5f, false);
            case KnightPhantom.Formation.CHARGE_PLUSX -> this.getMoveAcrossPosition(true, true);
            case KnightPhantom.Formation.CHARGE_MINUSX -> this.getMoveAcrossPosition(false, true);
            case KnightPhantom.Formation.CHARGE_PLUSZ -> this.getMoveAcrossPosition(true, false);
            case KnightPhantom.Formation.ATTACK_PLAYER_START, KnightPhantom.Formation.HOVER -> this.getHoverPosition(8.5f);
            case KnightPhantom.Formation.CHARGE_MINUSZ -> this.getMoveAcrossPosition(false, false);
            default -> this.getLoiterPosition();
            case KnightPhantom.Formation.ATTACK_PLAYER_ATTACK -> this.getAttackPlayerPosition();
        };
    }

    private void switchToNextFormation() {
        List<KnightPhantom> nearbyKnights = this.boss.getNearbyKnights();
        if (this.boss.getCurrentFormation() == KnightPhantom.Formation.ATTACK_PLAYER_START) {
            this.boss.switchToFormation(KnightPhantom.Formation.ATTACK_PLAYER_ATTACK);
        } else if (this.boss.getCurrentFormation() == KnightPhantom.Formation.ATTACK_PLAYER_ATTACK) {
            if (nearbyKnights.size() > 1) {
                this.boss.switchToFormation(KnightPhantom.Formation.WAITING_FOR_LEADER);
            } else {
                switch (this.boss.method_6051().nextInt(3)) {
                    case 0: {
                        this.boss.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_SWORD.get()));
                        break;
                    }
                    case 1: {
                        this.boss.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_AXE.get()));
                        break;
                    }
                    case 2: {
                        this.boss.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_PICKAXE.get()));
                    }
                }
                this.boss.switchToFormation(KnightPhantom.Formation.ATTACK_PLAYER_START);
            }
        } else if (this.boss.getCurrentFormation() == KnightPhantom.Formation.WAITING_FOR_LEADER) {
            if (nearbyKnights.size() > 1) {
                this.boss.switchToFormation(nearbyKnights.get(1).getCurrentFormation());
                this.boss.setTicksProgress(nearbyKnights.get(1).getTicksProgress());
            } else {
                this.boss.switchToFormation(KnightPhantom.Formation.ATTACK_PLAYER_START);
            }
        } else if (this.isThisTheLeader(nearbyKnights)) {
            this.pickRandomFormation();
            this.broadcastMyFormation(nearbyKnights);
            if (this.isNobodyCharging(nearbyKnights)) {
                this.makeARandomKnightCharge(nearbyKnights);
            }
        }
    }

    private boolean isThisTheLeader(List<KnightPhantom> nearbyKnights) {
        boolean iAmTheLowest = true;
        for (KnightPhantom knight : nearbyKnights) {
            if (knight.getNumber() >= this.boss.getNumber()) continue;
            iAmTheLowest = false;
            break;
        }
        return iAmTheLowest;
    }

    private void pickRandomFormation() {
        switch (this.boss.method_6051().nextInt(8)) {
            case 0: 
            case 7: {
                this.boss.switchToFormation(KnightPhantom.Formation.SMALL_CLOCKWISE);
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this.boss.switchToFormation(KnightPhantom.Formation.CHARGE_PLUSX);
                break;
            }
            case 4: {
                this.boss.switchToFormation(KnightPhantom.Formation.CHARGE_MINUSX);
                break;
            }
            case 5: {
                this.boss.switchToFormation(KnightPhantom.Formation.CHARGE_PLUSZ);
                break;
            }
            case 6: {
                this.boss.switchToFormation(KnightPhantom.Formation.CHARGE_MINUSZ);
            }
        }
    }

    private void makeARandomKnightCharge(List<KnightPhantom> nearbyKnights) {
        int randomNum = this.boss.method_6051().nextInt(nearbyKnights.size());
        nearbyKnights.get(randomNum).switchToFormation(KnightPhantom.Formation.ATTACK_PLAYER_START);
    }

    private void broadcastMyFormation(List<KnightPhantom> nearbyKnights) {
        for (KnightPhantom knight : nearbyKnights) {
            if (knight.isChargingAtPlayer()) continue;
            knight.switchToFormation(this.boss.getCurrentFormation());
        }
    }

    private boolean isNobodyCharging(List<KnightPhantom> nearbyKnights) {
        boolean noCharge = true;
        for (KnightPhantom knight : nearbyKnights) {
            if (!knight.isChargingAtPlayer()) continue;
            noCharge = false;
            break;
        }
        return noCharge;
    }

    private class_243 getMoveAcrossPosition(boolean plus, boolean alongX) {
        float offset0 = (float)this.boss.getNumber() * 3.0f - 7.5f;
        float offset1 = this.boss.getTicksProgress() < 60 ? -7.0f : -7.0f + (float)(this.boss.getTicksProgress() - 60) / 120.0f * 14.0f;
        if (!plus) {
            offset1 *= -1.0f;
        }
        double dx = (float)this.boss.method_18412().method_10263() + (alongX ? offset0 : offset1);
        double dy = (double)this.boss.method_18412().method_10264() + Math.cos((float)this.boss.getTicksProgress() / 7.0f + (float)this.boss.getNumber());
        double dz = (float)this.boss.method_18412().method_10260() + (alongX ? offset1 : offset0);
        return new class_243(dx, dy, dz);
    }

    private class_243 getCirclePosition(float distance, boolean clockwise) {
        float angle = (float)this.boss.getTicksProgress() * 2.0f;
        if (!clockwise) {
            angle *= -1.0f;
        }
        double dx = (double)this.boss.method_18412().method_10263() + Math.cos((double)(angle += 60.0f * (float)this.boss.getNumber()) * Math.PI / 180.0) * (double)distance;
        double dy = (double)this.boss.method_18412().method_10264() + Math.cos((float)this.boss.getTicksProgress() / 7.0f + (float)this.boss.getNumber());
        double dz = (double)this.boss.method_18412().method_10260() + Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new class_243(dx, dy, dz);
    }

    private class_243 getHoverPosition(float distance) {
        double oz;
        double dx = this.boss.field_6038;
        double dy = (double)this.boss.method_18412().method_10264() + Math.cos((float)this.boss.getTicksProgress() / 7.0f + (float)this.boss.getNumber());
        double dz = this.boss.field_5989;
        double ox = (double)this.boss.method_18412().method_10263() - dx;
        double dDist = Math.sqrt(ox * ox + (oz = (double)this.boss.method_18412().method_10260() - dz) * oz);
        if (dDist > (double)distance) {
            dx = (double)this.boss.method_18412().method_10263() + ox / dDist * (double)distance;
            dz = (double)this.boss.method_18412().method_10260() + oz / dDist * (double)distance;
        }
        return new class_243(dx, dy, dz);
    }

    private class_243 getLoiterPosition() {
        double dx = this.boss.method_18412().method_10263();
        double dy = (double)this.boss.method_18412().method_10264() + Math.cos((float)this.boss.getTicksProgress() / 7.0f + (float)this.boss.getNumber());
        double dz = this.boss.method_18412().method_10260();
        return new class_243(dx, dy, dz);
    }

    private class_243 getAttackPlayerPosition() {
        if (this.boss.isSwordKnight()) {
            return class_243.method_24954((class_2382)this.boss.getChargePos());
        }
        return this.getHoverPosition(8.5f);
    }
}

